Review article

# Advancing a temporal framework for understanding the biology of nonsuicidal self- injury: An expert review

Mindy Westlund Schreinerj, Kathryn R. Cullen k

UniversityHospitalofChildandAdolescentPsychiatryndPsychotherapy,UniversityofBer,Bern,Switzerland   
bDepartmentofidddoleenttrterforoocicinesispialeidebegebe   
CDepartmentofsychology,HarvardUniversityCambridge,   
dDepartmentfyoogyollgeofbralrtsUivesityfnesotaneaolis   
eUnivesityff   
Cologne, Germany   
fDepartmentofhildnddolescentsyhatry,edicalUniversityViennaViennastri   
Departmentof Child andAdolescentPsychiatry andPsychotherapy,Universityof Ulm,Ulm,Germany   
Schol   
Departentfdottftlice   
DepartmentoftrolficinevesityUtaltkeCit   
k DepartmentfyiatryndehavioralSciences,dicalhol,Universtyofnnesota,neapolis,

# ARTICLEINFO

# ABSTRACT

Keywords:   
Nonsuicidal self- injury   
Neurobiology   
Temporal framework   
Traits   
States

Nonsuicidal self-injury (NssI) isaserious clinical problem,particularly for adolescents and youngadults.NsI is acomplex behavior that emerges through the intersecting effectsof social,psychological,and biological mechanisms.Although the social and psychological contributions to risk for developing NSSIare relatively wel understood and have guided the developmentof effective psychosocial treatments for self-injury,the biological mechanisms underlying NSSI have just begun to come to light.To evaluate and categorize the biologicalresearch conducted on the topic of NssI,we propose a model that distinguishes between trait and state markers.According tothis model,risk factors and mechanisms involved in NsSIcan be distinguished into both trait and state factors.Wereview the existing evidenceon distal biological traits (predictors)of NSSI,proximal biological traits (correlates)of NSSI,and biological states directly precedingor following NSSI.We conclude by providing recommendations for future research on the neurobiology of NSSI.

# 1．Introduction

# 1.1. Nonsuicidal self-injury

Nonsuicidal self-injury (NSSI) is a serious clinical problem,particularly for adolescents and young adults.NSSIis defined as “the deliberate, self-inflicted damage of body tissue without suicidal intent and for purposes not socially or culturally sanctioned"(International Society for the Study of Self-Injury,ISsS),and typically manifests as cuting, scratching,or banging the body (Whitlock et al.,2Oo6).According to a meta-analysis,the prevalence estimate for a single episode of NSSI in non-clinical samples is $1 7 . 2 \%$ among adolescents, $1 3 . 4 \%$ among young adults,and $5 . 5 ~ \%$ among adults (Swannell et al., 2014). NSSI has been introduced as a potential discrete diagnostic entity in the 5th edition of the Diagnostic and Statistical Manual of Mental Disorders (DSM-5) in Section 3 as a disorder warranting further research (APA,2O13).The prevalence of NSSI disorder (according to DSM-5 diagnostic criteria) is estimated at $0 . 3 { - } 5 ~ \%$ among non-clinical samples of adolescents,and between $5 0 \mathrm { - } 8 0 ~ \%$ among inpatient samples (Zetterqvist, 2015; Plener et al.,2Ol6).Critically,NSSI is a significant predictor of subsequent suicide (Mars et al., 2O19). Given its prevalence and increased mortality, the World Health Organization has recognized NSSI as one of the top five major health threats to adolescents (WHO, 2014).

# 1.2. The importance of advancing our understanding of the biology underlying NSSI

NSSI is a complex behavior that emerges through the intersecting effects of social,psychological,and biological mechanisms.Although the social and psychological contributions to risk for developing NSSI are relatively well understood and have guided the development of effective psychosocial treatments for self-injury (Kothgassner et al., 2020),the biological mechanisms underlying NSSI have just begun to come to light.To date,no somatic treatments such as psychopharmacology or neuromodulation are available for treating NSSI (Plener et al., 2018).Addressing this gap first requires greater knowledge of the biological mechanisms,which underlie dispositional factors,as well as the onset and maintenance of NSSI.

Critically,NSSI is a behavior that emerges during early adolescence (Plener et al., 2Ol5),a time period notable for significant brain development (Giedd et al., 1999,2009). The neuroplasticity inherent to such developmental periods represents both a vulnerability for the onset of mental health problems during adolescence,as well as an opportunity forpotentially enhanced intervention due to increased malleability (Paus et al., 2Oo8). Advancing our understanding of how and when neurophysiological processes go awry in adolescents who engage in NSSI will be critical in developing optimally-timed interventions designed to address the particular profile of interacting neurobiological, psychological and social mechanisms that are perpetuating a given individual's NSSI.

Here we provide a review of recent neurobiological research on NSSI and propose a theoretical model for understanding recent findings and guiding future inquiries.Given the complexity of the brain and its manifold connections,numerous research approaches are required to begin understanding the multiple intersecting systems that are implicated in the onset and maintenance of NSSI during adolescent development.The research approaches reviewed here include:(a) genetics and epigenetics,(b) brain structure,connectivity,activation patterns, neurotransmitters,and behavioral indicators of brain functioning (neurocognitive functioning),and (c) peripheral physiology including the autonomic nervous (ANS) and the neuroendocrine systems.These research approaches have been applied and integrated to examine multiple biological systems implicated in NsSI including those represented in negative affect, stress,pain,and social functioning. Critically, identified disruptions in these biological systems may reveal targets for developing novel interventions (e.g.，psychosocial， pharmacology, neuromodulation).

# 1.3.Model of distal and proximal trait biology as well as biological states around NSSI

To evaluate and categorize the biological research conducted on the topic of NSSI,we propose a model that distinguishes between trait and state markers,and thus is in line with advanced biological models of other mental disorders (e.g.,schizophrenia; Chen et al.，2Oo6).According to such a model,risk factors and mechanisms involved in NSSI can be distinguished into both trait and state factors.

A trait is a relatively stable,enduring characteristic or pattern of behavior or biological functioning,which plays an antecedent,possibly causal,role in the pathophysiology of psychiatric disorders.This broader definition of traits includes the manifestation of altered behavioral and biological processes that are not necessarily linked to NSSI,but to functional abnormalities related to the predisposition of this behavior. Some traits may serve as distal risk factors,meaning that a biological predisposition or vulnerability for NSSI was already present at birth or early in life,or developed over a long period of time (so-called

![](images/4311b624b83dc997684cf6fd73e4711da6c003f1af4a633ab9a119099d7c3f53.jpg)  
Fig.1.Model of different categories of the biological factors in NSSI.

distal biological traits; see Fig.1).

However,most biological traits that have been investigated in the context of NsSI are more proximal in nature,as studies have predominantly used cross-sectional designs,which capture more proximal correlates of ongoing NSSI (so-called proximal biological traits; see Fig.1). These traits represent potentially underlying biological processes that are of moderate stability but are not expected to change within days or even weeks.In contrast,a state is a temporary way of being (i.e., thinking，feeling，behaving，and relating）or a transient biological marker or mechanism that reflects the current status of clinical manifestations in individuals with NSSI.Research on biological states in NSSI has been particularly focused on proxies of NSSI incidents (i.e. the experimental exposure to stress or pain),trying to understand the biological processes that unfold across an NSSI episode (i.e., the moments immediately before,during,and immediately after; see Fig.1).According to our model,the biological characteristics related to the development, onset, execution,and maintenance of NsSI can be divided into:

· distal biological traits (i.e.,genetic factors or risk factors that predict the development of NSSI),   
·proximal biological traits defined as underlying biological alterations observed among individuals who engage in NsSI (i.e.,alterations in brain structure and functioning as well as endocrine and physiological systems),and   
· biological states that directly precede or follow NSSI (i.e., changes in brain functioning as well as reactivity of endocrine and physiological systems).

Weaim to summarize the existing evidence on the biology of NSSI following this classification approach.As a result,specific biological systems are discussed in multiple sections within this review depending on their potential fit into the model described above.

# 2.Distal biological traits (predictors)

Although we are still in the early stages of identifying and understanding the distal risk factors present in childhood that increase an individual's vulnerability to NSSI,some research to date has focused on genetic predisposition,childhood maltreatment,and the interaction between genes and maltreatment.

# 2.1. Genes

Currently,little is known about potential genetic influences on the development of NsSI,and the few studies that have investigated the role of genes have yielded mixed findings.In a twins study,genetic influences explained only thoughts about NSSI,but not NSSI behavior (Jang et al., 1996).In contrast, based on a large sample of adult twins, genetic factors explained about $3 7 \ \%$ and $5 9 \ \%$ of variance in NSSI among males and females,respectively (Maciejewski et al.,2O14).A small body of research has investigated the role of specific genes in the manifestation of NSSI,with a focus on genes relevant to neural systems implicated in emotion.First,several studies have targeted a polymorphism of the serotonin-transporter linked promoter region (5-HTTLPR).No significant main effects of the 5-HTTLPR on the occurrence of NSSI were found in a sample of male prisoners (Gorodetsky et al., 2Ol6) or between groups of adults receiving inpatient care who reported a history of suicide attempts or NSSI (Dell'osso et al., 2013). Steiger et al. (2O11) failed to find a relationship between variants of the 5-HTTLPR and self-harming behavior,defined as NSSI and/or suicidal behavior,in independent samples of adult females with eating disorders.However,in the same study,high-function variants of the monoamine oxidase A(MAOA) gene were associated with increased risk of self-harming behavior (Steiger et al., 2Oll).With regard to polymorphisms of the catechol-O-methyl transferase (COMT） gene，no significant diferences were found between groups of adults receiving inpatient care who reported a history of suicide attempts or engagement in NSSI (Dell'osso et al., 2013). In contrast, Bernegger et al. (2018) found a haplotype of COMT polymorphisms (consisting of rs737865, rs6269,and rs4633) was associated with NSSI among adults with affective disorders.A main effect on NSSI was further reported for a polymorphism of the gene encoding for G protein β3 (GNβ3) among people from different age groups with depressive disorders (Joyce et al., 2006).

To date,only three studies have focused on potential geneenvironment interactions in predicting NSSI. Hankin et al. (2O15) reported results from two independent population-based samples of children and adolescents,showing that youth with at least one short variant of the 5-HTTLPR exhibited higher rates of engagement in NSSI when experiencing severe interpersonal peer stress.Moreover,a relationship between reports of an invalidating emotional environment during childhood and the development of NSSI was found only among Val carriers of the brain derived neurotrophic factor (BDNF;Val66Met polymorphism) compared to Met carriers (Hankin et al.,2O15).In a population-based sample of Chinese adolescent males,Gao et al. (2021) found a three-wave interaction between experiences of childhood abuse with variants of the MAOA and COMT genes in the prediction of NSSI: only in a subgroup of carriers with the Tallele of the MAOA gene and the Met allele of COMT, there was no significant relation between experiences of abuse and the development ofNSSI.

A significant limitation of most of the research to date reporting genetic main or interaction effects on NSSI is that these studies have relied on sample sizes of approximately 5O-5oo individuals.For this reason,such studies have limited potential to detect the usually small effects of single gene variants and may be strongly influenced by sampling errors.To our knowledge,only one study relied on a large population-based sample of close to 1oo,ooo adults; in this genomewide association study,no polymorphism was significantly related to NSSI (Strawbridge et al., 2019).

# 2.2.Epigenetics

To the best of our knowledge,only one study has thus far investigated the role of epigenetic changes in the context of NSSI. Martin-- Blanco et al. (2Ol4) found that methylation status of the promoter region of the glucocorticoid receptor gene (NR3Cl,exon 1 F) was positively associated both with a history of childhood maltreatment and with severity of self-injurious behaviors in a sample of adults with borderline personality disorder (BPD).While the extant evidence suggests that childhood adversity may cause epigenetic alterations that increase vulnerability for NSSI, there are no studies to date investigating any biological markers that precede the onset of NSSI, neither in optimal rearing environments nor in the context of stress or childhood adversity.

# 2.3.Biological manifestations of childhood maltreatment

A large body of literature has reported associations between the development of NSSI and a history of adverse childhood experiences, including child abuse and neglect (Serafini etal., 2Ol7) and other forms of childhood adversity (Kaess et al., 20l3). Building on data from a large study of families (Paul and Ortin,2O19) as well as on a representative community population sample (Brown et al., 2Ol8),it is still a matter of continuing debate,whether a history of child abuse and neglect is best understood as a direct risk factor for NSSI,or rather as a factor creating a broader,more indirect vulnerability for psychiatric sequelae,which then increases the likelihood of engaging in NSSI.Regardless,it is important to consider neurobiological findings from studies of child abuse and neglectas they may shed light on later vulnerability to NSSI and can foster our understanding of how environmental factors can influence biological systems.Although an in-depth discussion of the mechanisms involved in child abuse and neglect is beyond the scope of this review,a large body of literature,which has been summarized in various reviews,has described how chronic child abuse and neglect leads to alterations in the hypothalamic-pituitary-adrenal (HPA) axis (Kuhlman et al., 2Ol7), brain structure and function (Teicher et al., 2016),and inflammation (Danese and Baldwin, 2O17). Taken together, this research suggests that these biological systems may be particularly important to consider in relation to NSSI.

# 3.Proximal biological traits (correlates)

Most neurobiological research on NSSI to date has consisted of crosssectional studies comparing individuals with versus without NSSI.As such,this body of research has provided new knowledge about proximal biological traits associated with NSSI.As reviewed below,neurobiological domains of focus have included brain circuitry,peripheral stress response systems including the autonomic nervous system and the HPA axis,and pain systems.In this section we discuss the research examining these systems and their function in general,while in Section 3("Biological States that Directly Precede or Follow NSSI")we discuss current knowledge about how these neurobiological systems function surrounding NSSI episodes.

# 3.1．Brain circuitry correlates of NSSI

Measurement of brain structure and function using non-invasive neuroimaging techniques is a key strategy to identifying proximal biological traits associated with NSSI. Although it is important to note that neuroimaging research on NSSI is still in the early stages,here we integrate the extant literature in terms of systems of neuro-behavioral functioning.

# 3.1.1. Circuits underlying emotion expression and regulation

Since NSSI is most often (but not exclusively) used to regulate emotions (Nock, 20o9; Plener et al., 2016),research investigating the processes involved in emotion experience and regulation is important for shedding light on this behavior.Studies on individuals with NSSI commonly reveal deficits in cognitive emotion regulation skills such as compromised reappraisal and a tendency to suppress emotions (Andover and Morris, 2014; Tatnell et al., 2017). To date, neuroimaging studies haveprovided convergingevidenceimplicatingalterationsin fronto-limbic neural systems in NSSI,which are centrally involved in emotion processing and expression (Phillips et al.，2003).Key fronto-limbic structures include the amygdala,a core region for the processing of negative emotion and threat (Ledoux, 2Ooo; Lindquist et al.,2Ol6); frontal regulatory regions such as the anterior cingulate cortex (ACC),medial prefrontal cortex (PFC) and dorsolateral PFC; the hippocampus (emotional memory and HPA regulation; (Lupien et al., 2009);and the insula (emotional salience processing; (Seeley et al., 2007). Structurally,NSSI has been associated with reduced grey matter volume in the insula and the ACC in adolescent outpatients (Ando et al., 2018).An initial diffusion imaging study reported that adult outpatients with BPD and self-injurious behavior showed compromised white matter microstructure within the frontal lobe (Grant et al., 2Oo7). This was further supported by a study that found that adolescents and young adults with NSSI showed lower white matter integrity compared to healthy controls in widespread circuits,and that reduced white matter integrity of fronto-limbic tracts correlated with NSSI duration (Westlund Schreiner et al.，2O19).Functionally,adolescents with NSSI showed greater resting-state functional connectivity between the amygdala and posterior regions of the ACC relative to healthy controls (Westlund Schreiner et al., 2017).

Functional imaging paradigms probing brain activation in the context of emotional experiences provide further support implicating emotion reactivity and regulation in NSSI. In the first fMRI study to examine this,adolescent patients with NSSI showed greater amygdala and ACC activation in response to negative,positive and neutral pictures compared to healthy controls (Plener et al., 2Ol2),suggesting heightened emotional reactivity in this population.Notably,in a study with non-hospitalized adults with NSSI (but without BPD),these effects were not apparent in comparison to a clinical control group without NSSI matched for psychopathology,although the NSSI group was still less able to down-regulate their amygdala activity using reappraisal than matched controls (Davis et al., 2Ol4). Taken together, research findings to date implicate fronto-limbic circuitry in neurobiological vulnerability to impaired processing of emotional stimuli in adolescents with NSSI.

# 3.1.2. Social / self neural systems

The neural systems that underlie how young people think about themselves are highly relevant to understanding NSSI. The stressful events that trigger NSSI episodes are often social in nature.People who self-injure are more likely to have problematic relationships with their parents and are often victims of bullying (Esposito etal., 2O19; Liu et al., 2018; Tatnell et al., 2Ol7). In addition, interpersonal stressors such as trouble with parents or a serious argument with a close friend predict the first onset of self-injury (Kaess et al.,2O2O). The brain networks underlying processing of self and others overlap to some extent with the front-limbic networks discussed above; the“social brain"is comprised of medial PFC, temporoparietal junction,posterior superior temporal sulcus,inferior frontal gyrus,interparietal sulcus,amygdala,ACC,and anterior insula (Blakemore,2Oo8) while brain networks specific to self processing is thought to be comprised of medial cortical regions (medial PFC/ACC,ventrolateral PFC，posterior cingulate and precuneus) together with angular gyrus, temporo-parietal junction, temporal pole, posterior temporal sulcus (Pfeifer and Peake, 2Ol2). Together, many of these regions also contribute to the salience and default mode networks. A recent study found that in a sample of adolescents,patients with depression and NsSI demonstrated reduced connectivity at rest within the salience and default mode networks relative to patients with depression but no NSSI and healthy controls (Ho et al.,2021).A strength of this study is the use of both clinical and healthy controls,which suggests that findings may be unique to NSSI rather than due to general psychopathology.

Using social exclusion paradigms,several studies have now demonstrated that compared to healthy control participants,adolescent and adult patients with NSSI demonstrate greater activation of fronto-limbic /social brain network regions during social exclusion including the ACC (Brown et al., 2017; Malejko et al., 2019), insula (Malejko et al., 2019), ventrolateral and medial PFC,and parahippocampal gyrus (Groschwitz et al.,2Ol6). These findings of fronto-limbic overactivation to social threat (along with elevations on self-report measures of rejection sensitivity)have generally been interpreted as reflecting higher rejection sensitivity coupled with unsuccessful efforts to regulate feelings of rejection among those with NSSI.In a study where adolescents took either their own or someone else's perspective to judge self-related characteristics,adolescents with both depresson and NSSI had higher limbic activity across all perspective-taking conditions,compared to both depression-only and healthy controls,especially when taking their mother's perspective,and particularly for those who perceived low emotional support from their mothers (Quevedo et al., 2016).Hence, the neural circuits underlying emotion processing intersect with those underlying processing of self/other,likely reflecting the emotional difficulties that occur in social contexts given that interpersonal difficulties are common for individuals with NSSI.

# 3.1.3. Cognitive control

Research has provided some some evidence that individuals with NSSI may demonstrate greater impulsivity,which could help explalin their vulnerability in developing and maintaining this behavior. The deliberate implementation of emotion regulation strategies is a complex process which entails both a decision $i f$ and how to regulate (Sheppes et al.,20l4) as well as the suppression of alternative impulses.The brain regions which together execute cognitive control functions (a set of higher cognitive tasks including impulse control) include the dorsolateral PFC,ACC,dorsal parietal cortex and precentral gyrus (Williams, 2017).Some studies but not others have found correlates between impulsivity and other indexes of cognitive control with NSSI (McHugh et al.,2Ol9).To date,brain correlates of cognitive control are a relatively understudied area in NSSI research. One study showed that during a cognitive interference task,adults with NSSI showed no deficits in suppressing distracting information on a behavioral level but showed greater dorsolateral PFC activity relative to controls. In the NSSI group, this activity was positively associated with self-reported global levels of emotional reactivity and impulsivity (Dahlgren et al.,2O18).At this time,there is not yet adequate information in the neuroimaging research showing a robust pattern with regard to cognitive control systems in NSSI.

# 3.1.4. Reward

The reward system represents an area of interest for NSSI research given open questions as to whether NSSI is maintained through either positive or negative reinforcement,and whether individuals with NSSI may exhibit reduced reward responsiveness to positive inputs or experiences.Central components of the reward network include the ventral striatum,orbitofrontal cortex (OFC) and ACC (Williams, 2017). To date, research on NSSI and reward has been mixed.While one study demonstrated enhanced striatal activation to monetary rewards in adolescents with NsSI (Poon et al., 2Ol9),another study showed lower activity of striatum,OFC,and amygdala in adolescents with NSSI during reward processing (Sauder et al., 2Ol6). Notably, the value of rewards is a central moderator in models on reward processing in adolescence (Galvan et al., 2006; Vaidya et al., 2013). A relatively large study reported higher OFC activity in adult patients with BPD with versus without NSSI, but only when rewards were unexpectedly high (Vega et al., 2Ol8).Moreover,in a community sample of adults with depression,abnormal connectivity between striatal and motor/sensory regions was correlated with self-injury,but not with depression or suicidal ideation (Marchand et al.,2Ol2) further implicating regions associated with reward processing in NSSI. Behavioral indicators of decision making under reward conditions have not consistently been linked with NSSI (McHugh et al.,2O19). Taken together, the findings to date on the reward system in NSSI are mixed,which will require further studies to disentangle.

In sum,neuroimaging studies have begun to investigate the role of neural systems involved in processing emotion,thoughts about self and other,cognitive control,and reward in NSSI.Notably,some of the neuroimaging correlates noted above have also been associated with stress exposure,especially during early life years (Lupien et al., 2009), suggesting a potential connection between more distal risk factors and proximal NSSI biomarkers.Given that these neurobiological systems are still undergoing development during adolescence,a critical next step in research will be to better understand how abnormalities in these systems change over time across development and in the context of treatment interventions.

# 3.2.Peripheral stress response systems

Biological systems centrally implicated in the human stress response potentially contribute to the risk for developing and maintaining NSSI. The autonomic nervous system (ANS) and the HPA axis are considered the two most important stress response systems,allowing the organism to functionally adapt to changing environmental demands.Given that individuals often engage in NSSI to regulate unpleasant experiences (Edmondson et al., 2016; Klonsky and Glenn, 2009),and that interpersonal stressors have particular influence for those individuals (Kaess et al.,202O),recent research aimed to answer the question whether the physiological stress response systems may be altered in NssI, including examination of both the basal functioning and the reactivity of these systems to acute stressors among individuals with NSSI.

# 3.2.1．Autonomic nervous system

The ANS regulates organ function in the context of rest (parasympathetic branch) and stress (sympathetic branch). Predominantly, ANS activity in NSSI is studied by investigating its innervation of the heartand skin.Psychophysiological methods allow the quantification of resting ANS activity and phasic response to certain stimuli.Initial evidence for potential alterations in resting ANs functioning came from comparisons of vagally-mediated heart rate variability (HRV)—a proxy of cardiac parasympathetic activity—among adolescents with deliberate self-harm and age-matched controls (Crowell et al.,20o5).Results indicated that adolescents with deliberate self-harm demonstrated reduced vagally-mediated HRV(i.e.,lower parasympathetic activity)at rest.In contrast,resting cardiac function,as indexed by heart rate (mixedsympatheticandparasympatheticinfluence）and vagally-mediated HRV was not altered in a study comparing outpatient adolescents with NsSI to healthy controls,although cardiac function was negatively related to symptoms of BPD (Koenig et al., 2O17b). Greater severity of BPD pathology was also associated with increased heart rate and reduced HRV and these findings were recently replicated in an independent sample of adolescent patients (Weise etal.,2O2O).Additional analyses of Koenig et al. (2O17b) revealed that the relationship between resting cardiac function and dimensional personality pathology also held longitudinally (Koenig et al., 2O18). Overall, these data suggest that individuals with NSSI are characterized by an ANS profile reflecting greater sympathetic dominance,as a function of underlying dimensional personality pathology (e.g.,emotion regulation deficits).

In terms of cardiac reactivity to acute stress,adolescents with deliberate self-harm showed greater vagally-mediated heart rate variability during a sadness induction than age-matched controls (Crowell et al.,2Oo5),but adolescents with NSSI showed no differences in heart rate during a standardized psychosocial stress procedure (Kaess et al., 2012).Adults with eating disorders and NSSI also demonstrated no differences in in-task heart rate variability (during biofeedback video game play) compared to both healthy controls and adults with eating disorders and no NSSI (Giner-Bartolome et al., 2017).

Moving beyond cardiac indicators,evidence for systematic differences in NSSI across other domains of stress reactivity is mixed. Changes in skin conductance partially reflect the influence of the sympathetic nervous system on eccrine sweat gland secretion and provide a measure of physiological arousal. Nock and Mendes (2Oo8) compared skin conduction of a large sample of adolescents and young adults with NSSI to matched controls during a frustration task,finding that the NSSI group demonstrated greater physiological reactivity than controls.Notably, this difference was most pronounced at the end of the 14-minute task.In contrast,other research has found no difference in skin conductance levels by self-injury status during a standardized psychosocial stress procedure (Tatnell et al., 2O18), or in skin conductance responses during a sadness induction (Crowell et al., 2005).

# 3.2.2.Hypothalamic-Pituitary-Adrenal Axis

The HPA axis consists of the reciprocal neuroendocrine action of the hypothalamus,the anterior pituitary gland,and the adrenal glands and constitutes a major stress response system.Given that states of heightened stress typically precede acts of NSSI,examination of the functioning of this dynamic system under resting conditions,across the diurnal cycle,and in response to acute stressors has been critical to advancing our understanding of NssI.Although studies applying ecologically valid designs (e.g.,measuring ANS or HPA activity and reactivity surrounding events of NSSI in everyday life) are currently limited, lab-based experiments (e.g.,stress induction manipulations) may help to understand differences in ANS and HPA stress-reactivity in patients engaging in NSSI. Initial research found that adolescent girls with NsSI showed an attenuated salivary cortisol response to a standardized psychosocial stress procedure compared to those without a history of NSSI, suggesting a blunted cortisol response in NSSI (Kaess et al.,2012).Plener et al.(2017) found that adolescent girls from a longitudinal sample of children growing up in precarious living conditions,with a lifetime history of deliberate self-harm showed lower plasma cortisol over the course of the same psychosocial stress procedure than did those without deliberate self-harm.However,in contrast to Kaess et al.(2Ol2), the self-harm and control groups showed a similar reactivity pattern over the course of the stress procedure,perhaps reflecting differences in cortisol assessment (blood plasma compared to saliva).More recently，Klimes-Dougan et al. (20l8) replicated the blunted salivary cortisol response ina larger sample of adolescents with both depression and NsSI compared to healthy controls and adolescents with depression but no NSSI.While this pattern of aberrant HPA axis functioning was present in both males and females, the number of male participants was low,leaving some uncertainty as to whether males with NSSI may exhibit a different pattern (Klimes-Dougan et al., 2018). Notably,the severity of self-harm moderated the extent of blunted cortisol:adolescents with recurrent NSSI had lower levels of cortisol than those with one or two lifetime episodes of NSSI.

In addition to more standard reactivity paradigms,alternative methods of measuring HPA may provide a more nuanced picture of HPA functioning.Reichl et al.(2Ol6) found that compared to matched healthy controls,adolescents who had engaged in five or more episodes of NSSI demonstrated a greater cortisol awakening response (sharp increases in cortisol in the first $3 0 { \ - } 4 5 \ \mathrm { m i n }$ after awakening)，perhaps indicating greater expectation of difficulty during the day (Kramer et al., 2019),or poorer sleep quality.Notably, this elevated cortisol was not maintained throughout the day,as the NSSI and healthy control groups demonstrated similar diurnal slopes as well as basal cortisol levels across the past three months (as indexed by hair cortisol levels).In addition, childhood adversity moderated the diurnal cortisol slopes.Healthy controls who had experienced childhood adversity had flatted diurnal cortisol slopes while adolescents with NSSI who had experienced adversity had steeper slopes.Beauchaine et al.(2Ol5) assessed alterations in resting HPA axis functioning among adolescent girls with depression only compared to adolescent girls with depression and self-harm using a dexamethasone suppression test (DST).Consistent with the interpretation that NSSI may be characterized by maladaptive neuroendocrine processes,lower post-DST cortisol levels were associated with self-harm status over and above reports of internalizing and externalizing behavior.Most recently,in a study of adolescents with NSSI and their siblings,hair cortisol and saliva cortisol were measured before and after diagnostic interviews (Reichl etal.,2O19).Although the NSSI group reported higher levels of childhood adversity and showed higher levels of hair cortisol, they presented with a decrease of salivary cortisol during the retrieval of childhood adversities as part of the diagnostic interview (Reichl et al.,2O19),while no such changes were apparent in the sibling group.These findings point to an alteration in the HPA axis due to child abuse and neglect,which acts as a (often chronic) stressor with the potential to attenuate the cortisol response.

Importantly，a developmental progression from childhood to adolescence may take place in which adverse experiences may be related to a shift in HPA axis functioning.For example,a longitudinal study tracking young women from age 6 to age 30 found that females with a history of abuse who initially had high cortisollater showed low cortisol levels as adults (Trickett et al., 2O1O). Results from another longitudinal study found a relationship between childhood adversity and larger pituitary volumes leading to later HPA axis attenuation (Kaess et al., 2018), thereby supporting the hypothesis that childhood adversity may contribute to blunted cortisol response in adolescence and adulthood. However,long-term longitudinal research on HPA functioning to understand potential HPA axis functioning shifts in adolescents with NSSI has yet to be conducted.

# 3.3.Pain systems

Since NSSI by definition causes tissue damage,which typically involves some degree of pain,pain sensitivity has been an active area of

NSSI research.The central question in this field of research is whether reduced pain sensitivity represents a proximal trait,increasing the risk to engage in NSSI in the future,or rather is a consequence of previous NSSI (i.e.,adaptation hypothesis).Many studies in this area have been conducted with adults with a BPD diagnosis (e.g., Schmahl et al., 2006), while others have focused more specifically on adults with NSSI in community samples (e.g.,Hooley et al., 2OlO). Comparison samples unusually involve healthy controls.In addition,various types of laboratory pain stimuli have been used, including thermal (Franklin et al., 2012; Koenig et al., 2017a,c) electrical (Weinberg and Klonsky, 2012), and mechanical pressure (McCoy et al., 201O; Glenn et al., 2014) pain stimuli.Recent technological advances introduced a blade stimulus to induce non-injurious sharp mechanical pain (Shabes etal., 2Ol6), that is considered to better mirror the pain experience during actual acts of NSSI (i.e., cutting the skin).Although there is ongoing debate concerning the ecological validity of laboratory-based pain induction in people with NSSI, findings on reduced pain sensitivity in those engaging in NSSI are well-replicated.

A review and meta-analysis of data from 32 different studies, including various samples,concluded that individuals engaging in NSSI report greater pain threshold,greater pain tolerance and lower selfreported pain intensity compared to healthy controls (Koenig et al., 2016).Adults and adolescents with NSSI also show elevated pain endurance-a measure that reflects willingness or ability to endure pain after the onset of pain (pain tolerance minus pain threshold (see Glenn et al., 20l4; Hooley et al., 201O). Cross-sectional findings in adults with BPD further suggest that pain sensitivity may normalize following cessation of NSSI (Bekrater-Bodmann et al.， 2O15; Ludäscher et al., 2009).However,the only longitudinal study on pain sensitivity in adolescent NSSI showed that greater reduction in NSSI frequency after one-year was associated with increased pain tolerance.This finding suggests that individuals may disengage from NSSI once pain tolerance gets too high—perhaps due to attenuated effectiveness of NSSI for regulating emotion (Koenig et al., 2Ol7a).Although it is currently not possible to draw conclusions concerning the causal relationship between pain sensitivity and NsSI,the later finding supports the idea that pain sensitivity presents a proximal trait for the engagement in NSSI and the termination of the behavior. How age-related developmental changes may impact the association between pain sensitivity and NSSI warrants further research.

Pain sensitivity is a complex construct, driven by psychological and biological mechanisms.On the biological level, findings of diminished pain perception in people who engage in NSSI have given rise to suggestions of endogenous opioid involvement. Four distinct classes of endogenous opioids can be distinguished: endorphins,enkephalins, dynorphins,and endomorphins (see Bresin and Gordon,2Ol3).In a pioneering study, Coid et al.(1983) noted that plasma levels of enkephalins (but not $\beta$ -endorphin) were higher in adults with BPD who engaged in NSSI $( n = 1 0$ )compared to healthy controls. However, more recent research in larger samples suggests that levels of endogenous opioids may be lower in people who engage in NSSI compared to controls.Stanley et al. (20lO） examined CSF levels of $\beta$ -endorphin, met-enkaphalin,and dynorphin in adults with depression,a cluster B personality disorder (primarily BPD)and who had a history of suicide attempts; half of the sample had a history of NSSI. $\beta$ -endorphin and met-enkephalin levels were significantly lower in those with versus those without NSSI.No significant differences were noted for dynorphin. Based on these findings, Stanley et al.(2O1O) proposed an opioid deficiency model,with NSSI being used in an effort to restore homeostasis by increasing endogenous opioids.Findings suggesting a reduced resting plasma $\beta$ -endorphin levels have recently been replicated in adolescents engaging in NSSI (van der Venne et al., 2O2O).However,whether an opioid deficiency predates NSSI or is a consequence of NSSI engagement remains unclear.Further,studies were not able to confirm the suggested link between endogenous opioids and altered pain sensitivity in adolescents with NSSI (van der Venne et al., 2020).

It remains difficult to reconcile how lower resting levels of endogenous opioids are consistent with generally lower pain sensitivity in people who engage in NSsI. Increased activity at mu- and delta receptor sites is,in principle,associated with a decrease in pain sensitivity, consistent with the use of morphine (a mu-receptor agonist) being used clinically for pain management. If resting levels of $\beta$ -endorphin and metenkephakin are low,activity at mu and delta receptor sites would be expected to be reduced,leading to predictions of increased pain perception sensitivity. Of course,if an episode of NSSI is currently in process or has recently occurred, this would be expected to increase $\beta$ -endorphin levels, providing an explanation for reduced pain sensitivity (i.e., increased pain thresholds and longer pain endurance). However, this is not the case in most instances.An alternative explanation for pain analgesia (i.e.,lower pain sensitivity) in people who engage in NSSI may be that the pain of an experimental stimulus (e.g., heat, cold, pressure pain) triggers the release of $\beta$ -endorphin. If we further assume that low resting levels of endogenous opioids result in mu and delta receptors becoming highly sensitive to opioids,this could potentially create a context in which pain analgesia might be reported.Empirical tests of this hypothesis remain to be conducted.Initial evidence from an ecological momentary assessment (EMA) study points to low salivary $\beta$ -endorphin levels,which are increased by NSSI events (Storkel et al.,2020).

Efforts to examine the role of these neuropeptides in NSSI are hampered by the overall limitation that neuropeptide levels obtained from plasma may not reflect neuropeptide levels centrally (De Riu et al., 1997).Also problematic for the opioid deficiency model is that NSSI tends to occur when a person is in a state of stress (Armey et al., 2011). Yet stress is associated with increased opioid activity (Butler and Finn, 2009).This means that: (a) NSSI is more likely to happen under conditions of elevated rather than reduced levels of endogenous opioids, and (b) opioids are not linked only to positive affective states.This pattern is the inverse of the opioid homeostasis model and challenges the idea that NSSI functions to increase low levels of endogenous opioids.However,the link between stress and increased opioid activity provides a possible explanation for the reduced pain perception that is found in many people who engage in NsSI. In summary, based on current knowledge,although it is certainly reasonable to expect that endogenous opioids might be involved in the mechanisms underlying reduced pain sensitivity in NSSI and NSSI per se,it is difficult to integrate these findings into a coherent theoretical framework at the present time.Multimodal studies assessing pain sensitivity,opioid levels at rest and following NSSI events in longitudinal designs are necessary to further understand these associations.While opioid blockers do reduce NSSI engagement to some extent in people with developmental disabilities (Symons et al.,2Oo4), treatments that increase opioid levels have also been shown to reduce NSSI (Nixon et al.， 2O03).Thus, although reduced pain sensitivity in NSSI has been well replicated, models of NSSI that are primarily based on imbalances of endogenous opioids are somewhat premature,given the current state of the evidence in this area.

# 4.Biological states that directly precede or follow NSSI

Although we do not yet have the availability of ethical,practical research approaches for measuring biological states directly before or during real-time NSSI events,as a surrogate approach,researchers have developed experimental paradigms to simulate NsSI to allow examination of biological states during proxy NSSI experiences.Such paradigms include application of painful stimuli such as heat,and even induction of injury using a blade.Application of such paradigms to measure selfreported stress and arousal has thus far suggested that the reduction of stress levels after a pain stimulus occurs regardless of whether the pain stimulus is associated with tissue injury (Wilis et al., 2O17),and that seeing blood appears to have an additional stress-dampening effect (Naoum et al.， 2O16). Studies applying these paradigms to examine evolving biological states associated with NSSI episodes,reviewed below, include approaches using neuroimaging to examine brain circuitry and stress-response paradigms to study peripheral response systems in the context of NSSI-like paradigms.

# 4.1.Brain circuitry changes during experimental NSSI paradigms

Studies to date (primarily focusing on adults with BPD and NSSI) that have applied neuroimaging approaches with NSSI-simulating experimental paradigms have generally implicated fronto-limbic (emotion expression/regulation) systems and pain systems in the neurobiological state changes that occur in the moments before,during and after NSSI episodes. In a first study by Schmahl et al. (2Oo6),adult inpatients with BPD and NSSI and healthy controls underwent an fMRI scan while heat stimuli were applied to their hands.The BPD group showed greater pain thresholds than healthy controls.When considering the effects of pain, individually-adjusted to threshold,the BPD group showed lower activation in amygdala and ACC but greater activation in dorsolateral PFC thanhealthycontrols,suggestingamechanisminwhich top-down-regulation of emotional components of pain modulate affective appraisal of pain. Kraus et al. (2OlO) explored neural processing of NSSI behavior in adult inpatients with and without BPD by measuring neural activation while participants imagined different aspects of an NSSI episode (e.g. the situation triggering an NSSI episode, emotional and cognitive reactions to the triggering situation, the NSSI act, the feelings after the NSSI act (Kraus et al., 2O1O). During the description of the trigger situation,people with BPD showed lower activation in the OFC but higher activation of the dorsolateral PFC than the control group.While imagining the NSSI act, the BPD group showed a significant decline in mid-cingulate activity (Kraus et al., 2O1O).To further examine the interaction between self-inflicted pain and affect regulation, Niedtfeld et al. (2O1O) used picture stimuli to elicit negative affect and thermal stimuli to induce heat pain in adults with and without BPD. While negative pictures were associated with greater fronto-limbic (amygdala,ACC,insula) activation in BPD versus controls,there was some evidence for attenuated activation in limbic areas (amygdala, insula) in response to painful stimulation for both healthy and BPD individuals (Niedtfeld et al., 2O1O).In a re-analysis of this data to further probe brain mechanisms underlying limbic deactivation (Niedtfeld et al.,2Ol2),researchers applied psychophysiological interaction analyses to assess how functional connectivity of amygdala,insula,and ACC changes across negative emotion and pain contexts.These results showed that painful sensory stimuli,as opposed to warmth perception, resulted in enhanced negative fronto-limbic coupling in patients BPD, suggesting a mechanism of inhibition of limbic arousal (Niedtfeld et al., 2012).A study that used an incision paradigm demonstrated a decrease of amygdala activity after incision and an additional restitution of post-stress amygdala-mPFC coupling following incision in an adult community sample with BPD and NSSI (Reitz et al., 2O15). The differential effect of incision versus a control condition was only found immediately after the painful stimulation (in the first five minutes), but disappeared afterwards (Reitz et al., 2O15),underscoring the importance of research approaches that can capture the transience of neurobiological states that transpire across NSSI episodes.In summary,early evidence from NSSI-simulation fMRI paradigms has shed light on how fronto-limbic and somatosensory neural systems interact and change across the NSSI episode in adult populations showing a high frequency of NSSI.

# 4.2.Peripheral stress response systems - changes across NSSI episode

Given the role of pain in NSSI, research has also considered ANS and HPA reactivity to painful stimulation in particular. Koenig et al. (2017c) assessed how the response of adolescent girls with NSSI $( n = 3 0 )$ compared to matched controls $( n = 3 0 )$ ) during a cold pain stimulation. Adolescents with NSSI showed a greater cortisol response to pain than did controls,a finding inconsistent with previous research showing a intractability—adolescents who have only experimented with NSSI once or twice may have very different neurobiological profiles than those with long-established patterns of frequent NSSI engagement. Given that that there is a clear developmental course of NSSI during adolescence (Plener et al.,2Ol5),a developmental psychopathology framework might be useful to guide future studies including its clinical implications (Beauchaine et al., 2019; Cicchetti, 2014). For example,it is plausible that the biology of NSSI largely differs when comparing young self-injuring individuals (e.g.at the onset of a variety of mental disorders) with older individuals with NSSI (e.g.with long-lasting borderline personality disorder).Thus, there is a dire need for longitudinal research in order to disentangle effects of age,duration of illness and severity of illess across the life-span. In addition,prospective studies beginning with at-risk youth to track the temporal changes across development and before and after the onset of NSSI are critical.For example,although much is now known about how childhood adversity can lead to adverse biological alterations,some of which are also seen in individuals with NSSI,there are no studies to date investigating biological markers in maltreated youth which precede the onset of NSSI. Thus,longitudinal studies elucidating biology $\mathbf { X }$ environment interactions over time could shed light on important questions of risk and resilience with regards to NSSI. Other at-risk groups that would be important to study longitudinally include children with psychopathology such as depression symptoms or impulse control problems,and/or children witha familial risk for suicidal behavior.

Table 1   

<html><body><table><tr><td rowspan="7">mes-Dougan et al.,2O18).Although the NsSI group showed similar systolic and diastolic blood pressure following painful stimulation, compared to matched controls,adolescents with NsSI demonstrated less vagal withdrawal (i.e.,greater heart rate variability) during the antici- pation of pain,as well asa slowerreturn to baseline (i.e.,decreased heart rate variability) during recovery from pain.The relative delay in recovery was associated with greater self-reports of better body aware- ness in those engaging in NSSI,an interesting finding suggesting a bio- logical basis of the anti-dissociative function of NSsI based on autonomic arousal.Additional analyses of the NSSI subsample revealed tatisproife childhood trauma showed greater decreases in heart rate variability both during and following painful stimulation,as well as a stronger cortisol response to pain (Rinnewitz et al., 2O18). Additional evidence for arousal comes from a single case where nocturnal urinary cortisol levels were assessed for 86 consecutive nights in a woman diagnosed</td><td colspan="3">Summary of the key findings*on the biology of NSSI.</td></tr><tr><td></td><td>Category</td><td>Key findings Heritability of NSSI is estimated to be 40-60 %; however,no clearly identifiable genetic factors have</td></tr><tr><td rowspan="3">Dital folg al</td><td>Genes</td><td>yet been identified.A few significant gene X environment interactions have been identified suggesting that the interaction between stressors and genes may increase risk for NSSI.</td></tr><tr><td>Epigenetics</td><td>The sffiensedencefr deildoent f sty ad gthe types of acute or chronic stressors) increase risk for NSSI. Such</td></tr><tr><td>Biological scares (cildhaodet)</td><td>adversitymay lead to alterations inthe Hsiaiarata pathways,which may represent a pathway to NSSI. The latter is still to be proven. There is converging evidence for alterations in fronto-limbic neural systems in NSSI, which are</td></tr><tr><td>conflicting at first hand. However,as detailed elsewhere (Koenig et al., 2017a,b,c), it may be the case that insuficient support by endogenous biological systems in the face of stressful situations (i.e.,as indexed by cortisol hyporeactivity) may be compensated by a hyperreactivity of the respective systems towards painful stimulation. This assumption may explain maintenance of NSSI as a dysfunctional strategy to regulate stress.</td><td>Brain circuitry Proximal biological</td><td>processing systems,fronto-limbic commonly found in individuals with NSSi. While individuals with NSSI are commonly judged as “impulsive&quot;,there is a lack of evidence for reduced cognitive control in NSSI. Similarly, research on the reward system remains inconclusive and requires Individuals with NSSI seem to be characterized by an ANS profile</td></tr><tr><td>5.Some remaining questions and future research While not a comprehensive review,this theoretical paper identifies</td><td>traits</td><td>further research. reflecting greater sympathetic dominance.Regarding the HPA</td></tr><tr><td>key insights that have been gained through neurobiological research (for a summary of key findings see Table 1) on the proximal and distal neurobiological traits,and the evolving biological states associated with NSSI,and highlights key gaps in knowledge. One major area in need of advancement is the confirmation of findings through replication with larger samples.This is true not only for</td><td>Peripheral stress response system</td><td>axis,there is converging evidence for an attenuated cortisol response to stress in individuals with NSSI which research on other HPA axis indices remains largely inconclusive so far.</td></tr><tr><td rowspan="3">genetics research on NsSI, but also the other neurobiological approaches which have suffered from small samples that introduce the risk for spurious findings, non-representative results,and type 2 error due to low power.Along these lines,the field is still in the early stages of under- standing heterogeneity in NSSI, which further adds to the need for larger samples.For example,the neurobiological mechanisms invoked in in- dividuals who utilize NSSI for regulating negative affect likely differ from those using it to serve interpersonal functions. Future neurobio- logical research would benefit from study designs and sample sizes that would allow parsing out heterogeneity related to NSsI function and other sources.</td><td rowspan="3">Biological states that directly precede or follow NSSI</td><td></td></tr><tr><td>Individuals with NSSI show Pain systems decreased sensitivity to pain. There is increasing evidence for a basal lack of endogenous opioids.</td></tr><tr><td>There is early evidence for an interaction of somatosensory Brain circuitry neural systems (i.e., in response to pain) and fronto-limbic systems (i. e.,decrease ofamygdala activity) across the NSSI episode.</td></tr></table></body></html>

\* Please note that “key findings”in the table are subject of interpretation by the authors.A more details and comprehensive review of the findings can be found in the text.

Accumulating data show that clinically-relevant NSSI in particular is associated with high levels of psychiatric comorbidity (Ghinea et al., 2020).Thus,studying NSSI without comorbid disorders would certainly lack external validity,while also raising the concern that current empirical data on NSSI may be largely driven by underlying comorbidity.Research designs that control for underlying comorbidity may advance our understanding of specific traits and states associated with NSSI.

Although research paradigms simulating NSSI have helped advance our understanding of the biological states which evolve over the course of NSSI episodes,we still lack critical knowledge on how biological changes transpire in real-world NSSI episodes.Moving forward,studies using EMA that include biological markers (i.e.,cortisol, ECG or betaendorphin） have promise for shedding light on real-world biological states that evolve before,during and after NSSI episodes.Fifth,animal models on NSSI would allow researchers to dive deeper into the biological mechanisms of NSSI.

Animal models have made significant contributions to our understanding of basic biology,and have provided insights into a broad variety of human central nervous system pathologies (Mumtaz et al., 2018),and this includes disorders in which NSSI is manifest (Goetghebeur and Swartz,2Ol6).However, little has been done to directly examine the neurochemical basis of NSSI.Evidence indicates that self-injury is not unique to humans.The forms of expression of self-injury are superficially different across species,but the underlying motivations and neurochemistry may have more in common than has previously been accorded.Thus,animal models appear to be an under-utilized resource for furthering our understanding of the neurobiology of NSSI.

Finally,research using existing or novel interventions as a probe to perturb the systems under investigation holds promise for shedding further light on the biology underlying NSSI and advancing treatment development. Experimental therapeutic interventions (e.g.，psychosocial interventions,cognitive training,meditation,psychopharmacology and ／ or neuromodulation strategies）which demonstrate target engagement (i.e.,create significant change in a biological marker plausibly related both to NSSI and to the intervention） and in turn demonstrate that this biological change corresponds to clinical improvement (e.g.,decrease in NssI) hold particular promise for advancing new and improved treatments for helping individuals desist, or potentially even prevent,NSSI.

As a very final note, there is a need that future research including its presentation and dissemination sets a stronger focus on the clinical implications of the biology of NssI. To date,the summarized findings on the biology of NSSI seem to guide and support a treatment focus on stress- and emotion regulation,and should increasingly be used to educate therapists,patients and caregivers for achieve a better understanding of the potential mechanisms for both NSSI and its treatment. However,more implications are warranted and may include a potential stratification of patients with NSSI according to their underlying biology.If we achieve a greater understanding of potential subgroups of NSSI (including their biology but also their estimated developmental course and potential response to treatment),we might one day get closer to our goal of personalized treatment for individuals with NSSI.

# References

Ando,A.,Reichl,C., Scheu,F.,Bykova,A.,Parzer,P.,Resch,F.,Brunner,R.,Kaess,M, 2018.Regional grey matter volume reduction in adolescents engaging in nonsuicidal self-injury.Psychiatry Res.Neuroimaging 280,48-55. https://doi.org/ 10.1016/j.pscychresns.2018.08.005.   
Andover,M.S.,Morris,B.W.,2014.Expanding and clarifying the role of emotion regulation in nonsuicidal self-injury.Can. J. Psychiatry 59,569-575.https://doi. org/10.1177/070674371405901102.   
Armey,M.F., Crowther,J.H.,Miller,I.W.,2011. Changes in ecological momentary assessment reported affect associated with episodes of nonsuicidal self-injury.Behav. Ther. 42, 579-588. https://doi.0rg/10.1016/j.beth.2011.01.002.   
Beauchaine, T.P., Crowell, S.E.,Hsiao,R.C.,2015.Post-dexamethasone cortisol, selfinflicted injury,and suicidal ideation among depressed adolescent girls.J.Abnorm. Child Psychol.43,619632. https://dorg/101007/s1080-014-9933-2.   
Beauchaine,T.P., Hinshaw, S.P., Bridge,J.A.,2o19.Nonsuicidal self-injury and suicidal behaviors in girls: the case for targeted prevention in preadolescence.Clin.Psychol. Sci. 7 (4), 643-667. https://doi.org/10.1177/2167702618818474.   
Bekrater-Bodmann,R.,Chung, B.Y.,Richter,I.,Wicking,M.,Foell,J.,Mancke,F., Schmahl, C.,Flor,H.,2o15.Deficits in pain perception in borderline personality disorder: results from the thermal grillillusion.Pain 156,2084-2092. https://doi. org/10.1097/j.pain.000000000000275.   
Bernegger,A.,Kienesberger,K.,Crlberg,Lwoboda,P,udwig,.oer,R, Inaner,M.,et al.,2oi8.The impact of COMT and childhood maltreatment on suicidal behaviour in affective disorders. Sci.Rep.8,692. https://doi.org/10.1038/ s41598-017-19040-z.   
Blakemore, S.J.,2oo8.The social brain in adolescence.Nat. Rev.Neurosci. 9,267-277. https://doi.0rg/10.1038/nrn2353.   
Bresin,K.,GordnK.3.dogenosidsdosicidalsel-: mechanism of affect regulation.Neurosci. Biobehav.Rev.37,374-383. https://doi. org/10.1016/j.neubiorev.2013.01.020.   
Brown,R.C.,Plener,P.L.,Groen,G.,Neff,D.,Bonenberger,M.,Abler,B.,2017. Diferential neural processing of social exclusion and inclusion in adolescents with non-suicidal self-injury and young adults with borderline personality disorder.Front. Psychiatry 8, 267. https://doi.org/10.3389/fpsyt.2017.00267.   
Brown,R.C.,Heines,S.,Witt,A.,Braehler,E.,Fegert,J.M.,Harsch,D.,Plener,P.L.,2018. The impact of child maltreatment on non-suicidal self-injury: data from a representative sample of the general population. BMC Psychiatry 18,181. https:// doi.org/10.1186/s12888-018-1754-3.   
Butler,R.K., Finn,D.P.,20o9. Stress-induced analgesia. Prog.Neurobiol.88,184-202. https://doi.org/10.1016/j.pneurobio.2009.04.003.   
Chen,Y.,Bidwell,L.C.,Norton,D.,2oo6.Trait vs.state markers for schizophrenia: identification and characterization through visual processes. Curr Psychiatry Rev 2, 431-438. https://doi.0rg/10.2174/157340006778699729.   
Ciccheti, D.,2014.Illustrative developmental psychopathology perspectives on precursors and pathways to personality disorder: commentary on the special issue. J. Pers. Disord.28 (1),172-179.https://doi.org/10.1521/pedi.2014.28.1.172.   
Coid,J.,Allolio,B., Rees,L.H.,1983.Raised plasma metenkephalin in patients who habitually mutilate themselves. Lancet 322, 545-546.https://doi.org/10.1016/ s0140-6736(83)90572-x.   
Crowell, S.E., Beauchaine,T.P.,McCauley,E., Smith, C.J., Stevens,A.L., Sylvers,P., 2005.Psychological,autonomic,and serotonergic correlates of parasuicide among adolescent girls.Dev.Psychopathol.17,1105-1127.https://doi.org/10.1017/ s0954579405050522.   
Dahlgren, M.K.,Hooley, J.M., Best, S.G., Sagar, K.A.,Gonenc,A., Gruber, S.A.,2018. Prefrontal cortex activation during cognitive interference in nonsuicidal self-injury. Psychiatry Res. Neuroimaging. 277, 28-38. https://doi.org/10.1016/j. pscychresns.2018.04.006.   
Danese,A., Baldwin, J.R.,2017.Hidden wounds? Inflammatory links between childhood trauma and psychopathology.Annu. Rev.Psychol.68,517-544. https://doi.org/ 10.1146/annurev-psych-010416-044208.   
Davis,T.S.,Mauss,I.B.,Lumian,D.,Troy,A.S.,Shallcross,A.J., Zarolia,P.,Ford, B.Q., McRae,K.,2ol4.Emotional reactivity and emotion regulation among adults with a history of self-harm: laboratory self-report and functional MRI evidence.J.Abnorm. Psychol.123,499-509.https://doi.org/10.1037/a0036962.   
De Riu,P.L.,Petruzzi, V.,Caria, M.A.,Mameli, O., Casu,A.R., Nuvoli, S., Spanu,A., Madeddu, G.,1997. Beta-endorphin and cortisol levels in plasma and CSF following acute experimental spinal traumas.Physiol. Behav.62,1-5.https://doi.org/ 10.1016/s0031-9384(97)00099-1.   
Dell'osso,L.,Mandeli,L.,Carlini,M., Bouanani, S.,Rotondo,A., Conversano, C., Serreti, A.,Marazziti, D.,2oi3.Temperamental and genetic predictors of suicide attemptandsef-utilation.Neuropschobiology.682525.hts://dog/ 10.1159/000356228.   
Edmondson,A.J., Brennan, C.A., House,A.O.,2o16.Non-suicidal reasons for self-harm: a systematic review of self-reported accounts.J.Affect. Disord.191,109-117.https:// doi.org/10.1016/j.jad.2015.11.043.   
Esposito,C., Bacchini, D.,Affuso,G.,2o19.Adolescent non-suicidal self-injury and its relationships with school bullying and peer rejection.Psychiatry Res.274,1-6. https://doi.org/10.1016/j.psychres.2019.02.018.   
Franklin,J.C.,Aaron,R.V.,Arthur,M.S.,Shorkey,S.P.,Prinstein,M.J.,2012. Nonsuicidal self-injuryand diminished painperception: theroleof emotion dysregulation.Compr.Psychiatry 53,691-700.https://doi.org/10.1016/j. comppsych.2011.11.008.   
Galvan,A.,Hare,A.PaaC.E.,enJ.,Voss,H,GoverG.aeyB.J, Earlier development of the accumbens relative to orbitofrontal cortex might underlie risk-taking behaviorinadolescents.J. Neurosci.26,6885-6892. https://doi.org/ 10.1523/jneurosci.1062-06.2006.   
Gao,Y., Xiong,Y., Liu, X.,Wang,H., 2O21. The effects of childhood maltreatment and non-suicidal self-injury in male adolescents: the moderating roles of the monoamine oxidase a (MAOA) gene and the catechol-O-methyltransferase (COMT) gene.Int. J. Environ.Res.Public Health 18,2598.htps://doi.org/10.3390/ijerph18052598.   
Ghinea,D.,Edinger,A.,Parzer,P., Koenig,J.,Resch,F.,Kaess,M.,2O2o.Non-suicidal self-injury disorder as a stand-alone diagnosis in a consecutive help-seeking sample of adolescents.J. Affect. Disord.274,1122-1125.https://doi.org/10.1016/j. jad.2020.06.009.   
Giedd,J.N.,Blumenthal,J.,Jeffries,N.O., Castellanos,F.X.,Liu,H., Zijdenbos,A., Paus,T., Evans, A.C., Rapoport, J.L.,1999. Brain development during childhood and adolescence:alongitudinal Mstudy.Nat.Neuroci.286-863.htps://doiorg/ 10.1038/13158.   
Giedd,J.N.,Lalonde,F.M., Celano,M.J.,White,S.L.,Wallace,G.L.,Lee,N.R.,Lenroot,R. K.,2009.Anatomical brain magneticresonance imagingof typicallydeveloping children and adolescents.J.Am. Acad. Child Adolesc.Psychiatry 48,465-470. https://doi.0rg/10.1097/CHI.0b013e31819f2715.   
Giner-Bartolome,C.,Mallorqui-Bagué,N., Tolosa-Sola,I., Steward,T., JimenezMurcia,S.,Granero,R.,Fernandez-Aranda,F.,2oi7.Non-suicidal self-injury in eating disordered patients:associations with heart rate variability and state-trait anxiety.Front.Psychol. 8,1163. https://doi.org/10.3389/fpsyg.2017.01163.   
Glenn,J.J.,Michel,B.D.,Franklin,J.C.,Hooley,J.M.,Nock,M.K.,2014.Pain analgesia among adolescent self-injurers.Psychiatry Res.220,921-926.https://doi.org/ 10.1016/j.psychres.2014.08.016.   
Goetghebeur,P.J.D.,Swartz,J.E.,2016.True alignmentof preclinical andcinical research to enhance success in CNS drug development: a review of the current evidence.J.Psychopharmacol. 30, 586-594. https://doi.org/10.1177/ 0269881116645269.   
Gorodetsky,E.,Carli,V., Sarchiapone,M.,Roy,A.,Goldman,D.,Enoch,M.-A., 2016. Predictors for self-directed aggression in italian prisoners include externalizing behaviors,childhoodtraumaand theserotonin transporter genepolymorphism5- HTTLPR.Genes Brain Behav.15,465-473.https://doi.org/10.1111/gbb.12293.   
Grant,J.E.,Correia, S.,Brennan-Krohn,T.,Malloy,P.F.,Laidlaw,D.H., Schulz, S.C., 2007.Frontal white matter integrity in borderline personality disorder with selfinjurious behavior. J. Neuropsychiatr.19,383-390.https://doi.org/10.1176/ jnp.2007.19.4.383.   
Groschwitz,R.C.,Plener,P.L.,Groen,G.,Bonenberger,M.,Abler, B., 2016.Differential neural processing of social exclusion in adolescents with non-suicidal self-injury: an fMRI study. Psychiatry Res.Neuroimaging 255,43-49. htps://doiorg/10.1016/j. pscychresns.2016.08.001.   
Hankin, B.L.,Barrocas,A.L,Young, J.F.,Haberstick,B., Smolen,A.,2015.5-HTTLPR $\times$ interpersonal stress interaction and nonsuicidal self-injury in general community sample of youth.Psychiatry Res.225,609-612. https://doi.org/10.1016/j. psychres.2014.11.037.   
Ho,T.C.,Walker,J.C.,Teresi, G..,Kulla,A., Kirshenbaum,J.S.,Gifuni,A.J.,Singh,M.K., Gotlib,I.H.,2o21.Default mode and salience network alterations in suicidal and non-suicidal self-injurious thoughts and behaviors in adolescents with depression. Transl. Psychiatry 11,38. https://doi.org/10.1038/s41398-020-01103-x   
Hooley,J.M.,Ho,D.T., Slater,J.,Lockshin,A.,2o1o.Pain perception and nonsuicidal self-injury:a laboratory investigation.Personal.Disord.1,17o-179.https://doi.org/ 10.1037/a0020106.   
Jang,K.L.,Livesley,W.J., Vernon,P.A.,Jackson,D.N.,1996.Heritability of personality disorder traits:a twin study.Acta Psychiatr. Scand.94,438-444. https://doi.org/ 10.1111/j.1600-0447.1996.tb09887.x.   
Joyce,P.R.,McKenzie,J.M.,Mulder,R.T.,Luty, S.E., Sullivan,P.F.,Miller,A.L., Kennedy,M.A., 2oo6.Genetic,developmental and personality correlates of selfmutilation in depressed patients.Aust.New Zeal.J.Psychiatr.40,225-229.https:// doi.org/10.1080/j.1440-1614.2006.01778.x.   
Kaess,M.,Hille,M.,Parzer,P., Maser-Gluth, C.,Resch,F.,Brunner,R.,2o12.Alterations in the neuroendocrinological stress response to acute psychosocial stress in adolescents engaging in nonsuicidal self-injury. Psychoneuroendocrinology 37, 157-161. https://doi.org/10.1016/j.psyneuen.2011.05.009.   
Kaess,M.,Parzer,P.,Mattern,M.,Plener,P.L.,Bifulco,A.,Resch,F.,Brunner,R.,2013. Adverse childhood experiences and their impact on frequency,severity,and the individual function of nonsuicidal self-injury in youth.Psychiatry Res.206, 265-272. htps://doorg/10.16/j.psychres.201.1012.   
Kaess,M.,Whittle,S.,O'Brien-Simpson,L.,Allen,N.B., Simmons,J.B.,2018.Childhood maltreatment, pituitary volume and adolescent hypothalamic-pituitary-adrenal axis -evidence for a maltreatment-related attenuation.Psychoneuroendocrinology 98, 39-45. https://doi.org/10.1016/j.psyneuen.2018.08.004.   
Kaess,M.,Eppelmann,L., Brunner,R.,Parzer,P.,Resch,F.,Carli,V.,Wasserman, C., et al.,2O2o.Life events predicting the first onset of adolescent direct self-injurious behavior-a prospective multicenter study.J.Adolesc.Health 66,195-201.https:// doi.org/10.1016/j.jadohealth.2019.08.018.   
Klimes-Dougan,B.,Begnel,E.,Almy,B.,Thai, M.,Westlund Schreiner,M.,Cullen,K., 2018.Hypothalamic-pituitaryadrenal axisdysregulationindepressedadolescents with non-suicidal self-injury.Psychoneuroendocrinology 102,216-224.https://doi. org/10.1016/j.psyneuen.2018.11.004.   
Klonsky,E.D., Glenn, C.R., 2oo9.Assessing the functions of non-suicidal self-injury: psychometric properties of the inventory of statements about self-injury (ISAS). J.Psychopathol. Behav.Assess.31,215-219. https://doi.org/10.1007/s10862-008- 9107-z.   
Koenig,J.,Thayer, J.F., Kaess,M.,2Ol6.A meta-analysis on pain sensitivity in selfinjury.Psychol. Med. 46,1597-1612. htps://doi.org/10.1017/ nn33201716000301   
Koenig,J.,Rinnewitz,L.,Niederbäumer,M., Strozyk,T.,Parzer,P.,Resch,F.,Kaess,M., 2017a.Longitudinal development of pain sensitivity in adolescent non-suicidal selfinjury.J. Psychiatr. Res.89,81-84.https://doi.org/10.1016/j. jpsychires.2017.02.001.   
Koenig,J.iewz,sh.JFKa cardiac function in adolescent non-suicidal self-injury: the impact of borderline personality disorder symptoms and psychosocial functioning.Psychiatry Res. 248, 117-120. https://doi.org/10.1016/j.psychres.2016.12.024.   
Koenig,J.,Rinnewitz,L.,Warth,M.,Hillecke,T.K., Brunner,R.,Resch,F.,Kaess,M., 2017c.Psychobiological response to pain in female adolescents with nonsuicidal self-injury.J.Psychiatry Neurosci.42,189-199.https://doi.org/10.1503/ jpn.160074.   
Koenig,J.,Weise,S.,innewitz,L,Parzer,P.,Resch,F.,Kaes,M.,018.Longitudinal covariance of resting-state cardiac function and borderline personality disorder symptoms in adolescent non-suicidal self-injury.World J.Biol.Psychiatry 19, 152-157. https://doi.0rg/10.1080/15622975.2017.1342046.   
Kothgassner,O.D.,Robinson,K.,Goreis,A.,Ougrin,D.,Plener,P.L.,2020. Does treatment method matter? A meta-analysis of the past 2O years of research on therapeutic interventions for self-harm and suicidal ideation in adolescents. Borderline Personal. Disord. Emot. Dysregul.7,9. https://doi.org/10.1186/s40479- 020-00123-9.   
Kramer,A.C.,Neubauer,A.B., Stoffel,M., Voss,A.,Ditzen,B.,2o19.Tomorrow's gonna suck: today's stress anticipation predicts tomorrow's post-awakening cortisol increase.Psychoneuroendocrinology 106,38-46.https://doi.org/10.1016/j. psyneuen.2019.03.024.   
Kraus,A., Valerius,G., Seifritz,E.,Ruf,M.,Bremner,J.D.,Bohus,M., Schmahl, C.,2010. Script-driven imagery of self-injurious behavior in patients with borderline personality disorder: a pilot FMRI study.Acta Psychiatr. Scand.121,41-51.https:// doi.org/10.1111/j.1600-0447.2009.01417.x.   
Kuhlman,K.R., Chiang,J.J.,Horn, S., Bower, J.E.,2017.Developmental psychoneuroendocrine and psychoneuroimmune pathways from childhood adversity to disease.Neurosci. Biobehav. Rev.80,166-184. https://doi.org/10.1016/j. neubiorev.2017.05.020.   
Ledoux, J.E.,2ooo.Emotion circuits in the brain.Annu. Rev.Neurosci.23,155-184. https://doi.org/10.1146/annurev.neuro.23.1.155.   
Lindquist, K.A., Satpute,A.B.,Wager, T.D.,Weber,J.,Feldman Barrett,L.,2016.The brain basis of positive and negative affect: evidence from a meta-analysis of the human neuroimaging literature. Cereb.Cortex 26,1910-1922. https://doi.org/ 10.1093/cercor/bhv001.   
Liu,R.T., Scopelliti, K.M.,Pittman, S.K., Zamora,A.S.,2o18.Childhood maltreatment and non-suicidal self-injury: a systematic review and meta-analysis.Lancet Psychiatry 5,51-64. https://doi.0rg/10.1016/s2215-0366(17)30469-8.   
Ludascher,P., Grefrath,W., Schmahl, C.,Kleindienst,N.,Kraus,A.,Baumgartner,U., Mgerl,Wee discontinuation of self-injury and normalizing pain perception in patients with borderline personality disorder.Acta Psychiatr.Scand.120,62-70.htps://doi.org/ 10.1111/j.1600-0447.2008.01335.x.   
Lupien, S.J.,McEwen, B.S.,Gunnar,M.R.,Heim,C.,20o9.Effects of stress throughout the lifespan on the brain,behaviour and cognition. Nat.Rev.Neurosci.10,434-445. https://doi.org/10.1038/nrn2639.   
Maciejewski,D.F., Creemers,H.E.,Lynskey,M.T.,Madden,P.A.F.,Heath,A.C., Statham, D.J.,Martin,N.G.,Verweij,K.J.H.,2014. Overlapping genetic and environmental influences on nonsuicidal self-injury and suicidal ideation: different outcomes,same etiology? JAMA Psychiatry 71,699-705. https://doi.org/10.1001/ jamapsychiatry.2014.89.   
Malejko,K.,Neff,D.,Brown,R.C.,Plener,P.L.,Bonenberger,M.,Abler,B.,Graf,H, 2019.Neural signatures of social inclusion in borderline personality disorder versus non-suicidal self-injury. Brain Topogr. 32,753-761. https://doi.org/10.1007/ s10548-019-00712-0.   
Marchand,W.R.,Lee,J.N.,Johnson,S.,Thatcher,J.,Gale,P.,Wood,N.,Jeong,E.-K., 2012.Striatalandcortical midlinecircuits inmajordepresson:implicationsfor suicide and symptom expression.Prog.Neuropsychopharmacol. Biol.Psychiatry 36, 290-299. https://doi.org/10.1016/j.pnpbp.2011.10.016.   
Mars,B.,J.CKo Gunnell, D.,2019.Predictors of future suicide attempt among adolescents with suicidal thoughts or non-suicidal self-harm: a population-based birth cohort study. Lancet Psychiatry6,327-337. https://doi.org/10.1016/s2215-0366(19)30030-6.   
Martin-Blanco,A.,Ferrer,M.,Soler,J., Salazar,J., Vega,D.,Andion,O.,SanchezMora, C.,et al.,2014.Association between methylation of the glucocorticoid receptor gene,childhood maltreatment,and clinical severity in borderline personality disorder.J. Psychiatr.Res.57,34-40.https://doi.org/10.1016/j. jpsychires.2014.06.011.   
McCoy,K.,Fremouw,W.,McNeil,D.W.,201o.Thresholds and tolerance of physical pain among young adults who self-injure.Pain Res.Manag.15,371-377.https://doi.org/ 10.1155/2010/326507.   
McHugh, C.M.,Chun Lee,R.S.,Hermens,D.F., Corderoy,A.,Large,M.,Hickie,I.B.,2019. Impulsivity in the self-harm and suicidal behavior of young people: a systematic review and meta-analysis.J. Psychiatr. Res.116,51-60. https://doi.org/10.1016/j. jpsychires.2019.05.012.   
Mumtaz,F.,Khan,M.1.,Zubair,M.,Dehpour,A.R.,2018. Neurobiologyand consequences of social isolation stress in animal model-a comprehensive review. Biomed.Pharmacother.105,1205-1222.https://doi.org/10.1016/j. biopha.2018.05.086.   
Naou,J.e.rsUz,iestis Baumgärtner,U.,Mancke,F., Treede,R.-D., Schmahl, C.,2016.The role of seeing hlnnd in non cuinidal calf iniirv in famala natiante urith hordarlina narennality disorder.Psychiatry Res.246,676-682. https://doi.org/10.1016/j. psychres.2016.10.066.   
Niedtfeld,I., Schulze,L., Kirsch,P.,Herpertz, S.C., Bohus,M., Schmahl, C.,201o.Afect regulation and pain in borderline personality disorder: a possble link to the understanding of self-injury.Biol. Psychiatry 68,383-391.htps://doi.org/10.1016/ j.biopsych.2010.04.015.   
Niedtfeld,I.,Kirsch,P., Schulze,L.,Herpertz, S.C.,Bohus,M., Schmahl,C.,2012. Functionalconnectivityofpain-mediated affectregulationin borderlinepersonality disorder.PLoS One 7,e33293. https://doi.org/10.1371/journal.pone.0033293.   
Nixon, M.K., Cheng, M., Cloutier, P., 2oo3.An open trial of auricular acupuncture for the treatment of repetitive self-injury in depressed adolescents. Can. Child Adolesc. Psychiatr. Rev.12,10-12.   
Nock, M.K.,2oo9.Why do people hurt themselves? New insights into the nature and functions of self-injury. Cur. Dir. Psychol. Sci.18,78-83.https://doi.org/10.1111/ j.1467-8721.2009.01613.x.   
Nock,M.K.,Mendes,W.B., 2oo8.Physiological arousal,distress tolerance,and social problem-solving deficits among adolescent self-injurers.J. Consult. Clin.Psychol.76, 28-38. https://doi.0rg/10.1037/0022-006x.76.1.28.   
Paul,E.,Ortin,A.2019.Psychopathological mechansmsofarlynglectandabuseon suicidal ideation and self-harm in middle childhood.Eur. Child Adolesc.Psychiatry 28,1311-1319. https://doi.0rg/10.1007/s00787-019-01287-8.   
Paus,T.,Keshavan,M.,Giedd,J.N,o8.Whydomanypsychiatricdisordersrge duringadolescence?Nat.Rev.Neurosci.9,947-957.htps://doiorg/10.1038/ nrn2513.   
Pfeifer,J.H,Peake,S.J.,0l2.Self-development:integratingcognitive,scioemotial and neuroimaging perspectives.Dev. Cogn. Neurosci.2,55-69. https://doi.org/ 10.1016/j.dcn.2011.07.012.   
Philips,M.,revets,W.C.,auch,S.L,ane,R,.Neurobiologyofmio perception II: implications for major psychiatric disorders.Biol.Psychiatry 54, 515-528. https://doi.0rg/10.1016/s0006-3223(03)00171-9.   
Plener,P.L.,Bubalo,N.,Fladung,A.K., Ludolph,A.G.,Lulé,D., 2012.Prone to excitement: adolescent females with non-suicidal self-injury (NSSI) show altered cortical pattern to emotional and NSS-Related material.Psychiatry Res.203, 146-152. https://doi.org/10.1016/j.pscychresns.2011.12.012.   
Plener,P.L., Schumacher,T.S., Munz, L.M., Groschwitz, R.C.,2015. The longitudinal course of non-suicidal self-injury and deliberate self-harm: a systematic review of the literature.Borderline Personal.Disord. Emot. Dysregul.2,2. https://doi.org/ 10.1186/s40479-014-0024-3.   
Plener,P.Llrogge,,austa,.,rale,E,egertJ,GrohitzC, 2016.The prevalence of nonsuicidal self-injury (NSSI) in a representative sample of the German population.BMC Psychiatry 16,353.https://doi.org/10.1186/s12888- 016-1060-x.   
Plener,P.L.,Zohsel,K.,Hohm,E.,uchmann,A.F.,Banaschewski,T.,Zimmermann, U.S, Laucht,M.,2017.Lowercortisollevelinesponsetoapschosocialstresoroung females withself-arm.Psychoneuroendocrinology76,8487.htps://doirg/ 10.1016/j.psyneuen.2016.11.009.   
Plener,P.L.,Kaess,K., Schmahl,C.,Pollak,S.,Fegert,J.M.,Brown,R.C.,2018. Nonsuicidal self-injury in adolescents.Dtsch. Arztebl.Int.115,23-30. https://doi. org/10.3238/arztebl.2018.0023.   
Poon, J.A.,Thompson,J.C.,Forbes,E.E.,Chaplin, T.M.,2019.Adolescents'rewardrelated neural activation: links to thoughts of nonsuicidal self-injury. Suicide Life Threat. Behav. 49,76-89. https://doi.org/10.1111/sltb.12418.   
Quevedo,K.,Ng,R., Scott,H.,Martin,J., Smyda, G.,Keener,M.,Oppenheimer,C.W, 2016.The neurobiology of self-face recognition in depressed adolescents with low or high suicidality.J.Abnorm.Psychol.125,1185-1200.https://doi.org/10.1037/ abn0000200.   
Reichl,C.,Heyer,A.,Brunner,R.,Parzer,P.,Volker,J.M.,Resch,F.,Kaess,M.,2016. Hypothalamic-pituitary-adrenal axis,childhood adversity and adolescent nonsuicidal self-injury.Psychoneuroendocrinology 74,203-211.https://doi.org/ 10.1016/j.psyneuen.2016.09.011.   
Reichl, C.,Bruer,R.eder,N.,arze,P.oenig,Jesch,.,ae,19. Adolescent nonsuicidal self-injury and cortisol response to the retrieval of adversity: asibling study.Psychoneuroendocrinology110,104460.htps://doi.org/10.1016/j. psyneuen.2019.104460.   
Reitz, S.,Krause-Utz,A.,Pogatzki-Zahn,E.M.,Ebner-Priemer, U.,Bohus,M.,Schmahl,C., 2012.Stress regulation and incision in borderline personality disorder-a pilot study modeling cutting behavior.J.Pers.Disord.26,605-615. https://doi.org/10.1521/ pedi.2012.26.4.605.   
Reitz,S.,Kluetsch,R., Niedtfeld,I.,Knorz,T.,Lis,S.,Paret, C.,Kirsch,P.,etal.,2015. Incision and stress regulation in borderline personality disorder: neurobiological mechanisms of self-injurious behaviour.Br.J.Psychiatry 207,165-172. https://doi. org/10.1192/bjp.bp.114.153379.   
Rinnewitz,L, Koenig,J.,Parzer,P.,Brunner,R.,Resch,F.,Kaess,M.,2o18.Childhood adversity and psychophysiological reactivity to pain in adolescent nonsuicidal selfinjury.Psychopathology 51,346-352. https://doi.org/10.1159/000491702.   
Sachsse,U., Von der Heyde,S.,Huether, G.,2oo2. Stress regulation and self-mutilation. Am. J.Psychiatry 159, 672. https://doi.org/10.1176/appi.ajp.159.4.672.   
Sauder, C.L., Derbidge,C.M., Beauchaine,T.P.,2016.Neural responses to monetary incentives among self-injuring adolescent girls.Dev.Psychopathol. 28,277-291. https://doi.0rg/10.1017/S0954579415000449.   
Schmahl, C.,Bohus,M.,Esposito,F.,Treede,R.-D.,Di Salle,F.,Greffrath,W., Ludaescher,P.,et al.,2oo6.Neural correlates of antinociception in borderline personality disorder. Arch. Gen. Psychiatry 63,659-667.https://doi.org/10.1001/ archpsyc.63.6.659.   
Seeley,W.W.,Menon, V.,Schatzberg,A.F.,Keller,J.,Glover,G.H.,Kenna,H.,Reiss,AL., Greiris MD 2nn7 Diccnriahle intrincir ronnertivitv netwnrks fnr calienre processing and executive control. J. Neurosci. 27, 2349-2356. https://doi.org/ 10.1523/JNEUROSCI.5587-06.2007.   
Serafini, G.,Canepa,G.,Adavastro, G., Nebbia,J.,Belvederi Murri, M.,Erbuto,D., Pocai,B.,et al.,2Ol7.The relationship between childhood maltreatment and nonsuicidal self-injury:a systematic review.Front. Psychiatry 8,149.https://doi.org/ 10.3389/fpsyt.2017.00149.   
Shabes,P.,hlo,N.,gerl,Whmahl,C.reede,R.-.Bumgartner,U,. A novel human surrogate model of noninjurious sharp mechanical pain.Pain 157, 214-224. https://doi.org/10.1097/j.pain.0000000000000352.   
Sheppes,G.cheibe,S.,Suri,G.,Radu,P.,Blechert,J.,Gros,J.J.,24.mi regulation choice: a conceptual framework and supporting evidence.J.Exp.Psychol. Gen. 143,163-181. https://doi.org/10.1037/a0030831.   
Stanley,B., Sher,L.,Wilson, S.,Ekman,R.,Huang,Y.-Y.,Mann,J.J.,2o1o.Non-suicidal self-injurious behavior,endogenous opioids and monoamine neurotransmitters. J. Affect. Disord.124,134-140. https://doi.org/10.1016/j.jad.2009.10.028.   
Steiger,H.,Fichter,M.,Bruce,K.R.,Joober,R.,Badawi, G.,Richardson,J.,Groleau,P., etal.,2011.Molecular-genetic correlates of self-harming behaviors ineatingdisordered women: findings from a combined Canadian-German sample.Prog. Neuropsychopharmacol. Biol.Psychiatry 35,102-106. https://doi.org/10.1016/j. pnpbp.2010.09.012.   
Storkel,L.M.,Karabatsiakis,A.,Hepp,J.,Kolassa,I.T.,Schmahl, C.,Niedtfeld,I.,020. Salivary Beta-Endorphin in Non-Suicidal Self-Injury:An Ambulatory Assessment Study.Preprint at PsyArXiv. https://doi.org/10.31234/osf.io/c6ksa.   
Strawbridge,R.J.,Ward,J.,Ferguson,A.,Graham,N., Shaw,R.J.,Cullen,B.,Pearsall,R., et al.,2019.Identification of novel genome-wide associations for suicidality in UK Biobank,genetic correlation with psychiatric disorders and polygenic association with completed suicide.EBioMedicine 41,517-525.https://doi.org/10.1016/j. ebiom.2019.02.005.   
Swannell, S.V.,Martin,G.E.,Page,A.,Hasking,P., St John,N.J.,2014.Prevalence of nonsuicidal self-injury in nonclinical samples: systematic review,meta-analysis and meta-regression. Suicide Life Threat. Behav.44, 273-303.https://doi.org/10.1111/ sltb.12070.   
Symons,F.J.,Thompson,A., Rodriguez,M.C.,2oo4. Self-injurious behavior and the efficacy of naltrexone treatment: a quantitative synthesis.Ment.Retard.Dev. Disabil. Res.Rev.10,193-200.https://doi.org/10.1002/mrdd.20031.   
Tatnell,R.,Hasking,P.,Newman,L.,Taffe,J.,Martin,G.,2017.Attachment,emotion regulation,childhood abuse and assault: examining predictors of NSSIamong adolescents.Arch. Suicide Res.21,610-620. https://doi.org/10.1080/ 13811118.2016.1246267.   
Tatnell,R.,Hasking,P.,Lipp,O.V.,Boyes,M.,Dawkins,J.,2018.Emotional responding in NSSI: examinations of appraisals of positive and negative emotional stimuli, with and without acute stress. Cogn. Emot.32,1304-1316.https://doi.org/10.1080/ 02699931.2017.1411785.   
Teicher,M.H.,Samson, J.A.,Anderson, C.M.,Ohashi,K.,2016.The effects of childhood maltreatment on brain structure,function and connectivity.Nat. Rev.Neurosci. 17, 652-666. https://doi.org/10.1038/nrn.2016.111.   
Trickett,P.K.,Noll, J.G., Susman, E.J., Shenk, C.E.,Putnam,F.W.,201o.Attenuation of cortisol across development for victims of sexual abuse.Dev.Psychopathol. 22, 165-175. https://doi.0rg/10.1017/s0954579409990332.   
Vaidya,J.G.,Knutson,B.,O'Leary,D.S.,Block,R.I.,Magnotta,V.,2013.Neural sensitivity to absolute and relative anticipated reward in adolescents.PLoS One 8, e58708. https://doi.org/10.1371/journal.pone.0058708.   
Van der Venne,P.,Balint,A.,Drews,E.,Parzer,P.,Resch,F.,Koenig,J.,Kaess,M.,2020. Painsensitivity and plasma beta-endorphin inadolescent non-suicidal self-injury. J. Affect.Disord. 278,199-208. https://doi.org/10.1016/j.jad.2020.09.036.   
Vega,D.,Ripolles,P.,Soto,A.,Torrubia,R.,Ribas,J.,Monreal,J.A.,Pascual,J.C,tal., 2018.Orbitofrontal overactivation in reward processng in borderline personality disorder: the role of non-suicidal self-injury. Brain Imaging Behav.12,217-228. https://doi.0rg/10.1007/s11682-017-9687-x.   
Weinberg,A.,Klonsky,E.D.,2Ol2.The effects of self-injury on acute negative arousal: a laboratory simulation.Motiv.Emot.36,242-254. https://doi.org/10.1007/s11031- 011-9233-x.   
Weise,S.,Parzer,P.,Zimmerman,R.,rerL,eshF.,ae,.Koenig,J Emotion dysregulation and resting-state autonomic function in adolescent borderline personality disorder - a multimodal assessment approach.Personal. Disord.11, 46-53. https://doi.0rg/10.1037/per0000367.   
Westlundhreinr,,im-Dogan.,eller,.brlyLE,eigsd,., Carstedt, P.A.,Thomas,K.M.,Hunt,R.H.,Lim, K.O., Cullen, K.R.,2O17.Multi-modal neuroimaging of adolescents with non-suicidal self-injury:amygdala functional connectivity. J.Afect. Disord. 221,47-55.https://doi.org/10.1016/j. jad.2017.06.004.   
Westlund Schreiner,M.,Mueller,B.A.,Klimes-Dougan, B., Begnel, E.D.,Fiecus,M., Hill,D.,Lim,K.O.,Cullen,K.R., 2019.White matter microstructure in adolescents and young adults with non-suicidal self-injury.Front.Psychiatry 10,1o19.https:// doi.org/10.3389/fpsyt.2019.01019.   
Whitlock,J.,Eckenrode,J., Silverman,D.,2oo6.Self-injurious behaviors in a college population.Pediatrics 117,1939-1948.https://doi.org/10.1542/peds.2005-2543.   
Williams,L.M.,2O17.Defining biotypes for depression and anxiety based on large-scale circuit dysfunction: a theoretical review of the evidence and future directions for clinical translation.DepressAnxiety34,9-24.htps://doiorg/10.102/da.22556.   
Wilis,F.,Kuniss,S.,Kleindienst,N.,Naoum,J.,Reitz,S.,Boll,S.,Bohus,M.,Treede,R D., Baumgärtner, U., Schmahl, C., 2ol7.The role of nociceptive input and tissue

# M. Kaess et al.

injury on stress regulation in borderline personality disorder.Pain 158,479-487. https://doi.0rg/10.1097/j.pain.0000000000000787. World Health Organization, 2o14. Health for the World's Adolescents: a Second Chance in the Second Decade. Executive Summary. https://www.who.int/maternal_child_ adolescent/documents/second-decade/en/ (Accessed 12 July 2020).

Zetterqvist,M.,2O15.The DSM-5 diagnosis of nonsuicidal self-injury disorder: a review of the empirical literature.Child Adolesc.Psychiatry Ment.Health 9,31.https://doi. org/10.1186/s13034-015-0062-7.